<?php
/**
 * Class MyUp_Updater
 * Τοποθεσία: myup-updater/class-myup-updater.php
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

if ( ! class_exists( 'MyUp_Updater' ) ) {

    class MyUp_Updater {
        private $slug;
        private $api_url;
        private $plugin_file;
        private $current_version;

        public function __construct( $plugin_file, $slug, $current_version, $api_url ) {
            $this->plugin_file = plugin_basename( $plugin_file );
            $this->slug = $slug;
            $this->current_version = $current_version;
            $this->api_url = $api_url;

            add_filter( 'pre_set_site_transient_update_plugins', [ $this, 'check_update' ] );
            add_filter( 'plugins_api', [ $this, 'check_info' ], 10, 3 );
        }

        public function check_update( $transient ) {
            if ( empty( $transient->checked ) ) return $transient;

            $remote = $this->request();
            
            if ( $remote && isset( $remote->version ) && version_compare( $remote->version, $this->current_version, '>' ) ) {
                $obj = new stdClass();
                $obj->slug = $this->slug;
                $obj->plugin = $this->plugin_file;
                $obj->new_version = $remote->version;
                $obj->url = $remote->download_url;
                $obj->package = $remote->download_url;
                $transient->response[ $this->plugin_file ] = $obj;
            }
            return $transient;
        }

        public function check_info( $false, $action, $arg ) {
            if ( $action !== 'plugin_information' ) return $false;
            if ( ! isset( $arg->slug ) || $arg->slug !== $this->slug ) return $false;

            $remote = $this->request();
            if ( ! $remote ) return $false;

            $obj = new stdClass();
            $obj->name = $remote->name;
            $obj->slug = $this->slug;
            $obj->version = $remote->version;
            $obj->download_link = $remote->download_url;
            $obj->sections = [
                'description' => $remote->sections->description ?? '',
                'changelog' => $remote->sections->changelog ?? ''
            ];
            $obj->last_updated = $remote->last_updated;
            return $obj;
        }

        private function request() {
            $remote = wp_remote_get( $this->api_url, [
                'timeout' => 10,
                'headers' => [ 'Accept' => 'application/json' ]
            ]);

            if ( is_wp_error( $remote ) || 200 !== wp_remote_retrieve_response_code( $remote ) ) {
                return false;
            }
            return json_decode( wp_remote_retrieve_body( $remote ) );
        }
    }
}
?>