<?php

class AnticWP_Core {

    private $license;
    private $printed = false;

    public function __construct( $license ) {
        $this->license = $license;

       
        if ( ! $this->license->is_valid() || get_option( 'anticwp_is_enabled', 'yes' ) !== 'yes' ) {
            return;
        }

        
        add_action( 'woocommerce_review_order_before_payment', array( $this, 'render_payment_mode_field' ), 10 );
        add_shortcode( 'anticwp_payment_mode', array( $this, 'shortcode_payment_mode' ) );

        
        add_action( 'wp_footer', array( $this, 'checkout_script' ) );
        add_action( 'woocommerce_checkout_update_order_review', array( $this, 'update_session_payment_mode' ) );
        add_action( 'woocommerce_cart_calculate_fees', array( $this, 'apply_fees_logic' ), 20 );
        
       
        
        
        add_filter( 'woocommerce_package_rates', array( $this, 'override_shipping_costs' ), 10, 2 );
        
       
        add_filter( 'woocommerce_shipping_rate_label', array( $this, 'force_fresh_shipping_label' ), 10, 2 );

        
        
        add_filter( 'woocommerce_cart_shipping_packages', array( $this, 'add_settings_to_shipping_hash' ) );
        
        
        add_filter( 'woocommerce_get_order_item_totals', array( $this, 'add_pay_later_row' ), 10, 3 );
        add_filter( 'woocommerce_available_payment_gateways', array( $this, 'disable_default_cod' ) );
        add_action( 'woocommerce_thankyou', array( $this, 'track_anticwp_usage' ) );
    }

    public function render_payment_mode_field() {
        if ( $this->printed ) return;
        $chosen_mode = WC()->session->get( 'anticwp_payment_mode', 'split' );
        ?>
        <div id="anticwp_payment_mode_wrapper" class="anticwp-box">
            <h3 class="anticwp-header">Επιλέξτε Τρόπο Πληρωμής</h3>
            <div class="anticwp-options-list">
                <label class="anticwp-opt <?php echo $chosen_mode === 'split' ? 'active' : ''; ?>">
                    <div class="anticwp-radio-wrap"><input type="radio" name="anticwp_payment_mode" value="split" <?php checked( $chosen_mode, 'split' ); ?>></div>
                    <div class="anticwp-content"><span class="anticwp-title">Μερική Αντικαταβολή</span><span class="anticwp-desc">Μόνο έξοδα τώρα.</span></div>
                </label>
                <label class="anticwp-opt <?php echo $chosen_mode === 'full' ? 'active' : ''; ?>">
                    <div class="anticwp-radio-wrap"><input type="radio" name="anticwp_payment_mode" value="full" <?php checked( $chosen_mode, 'full' ); ?>></div>
                    <div class="anticwp-content"><span class="anticwp-title">Ολική Εξόφληση</span><span class="anticwp-badge">ΔΩΡΕΑΝ ΑΝΤΙΚΑΤΑΒΟΛΗ</span></div>
                </label>
            </div>
        </div>
        <?php
        $this->printed = true;
    }

    public function shortcode_payment_mode() { ob_start(); $this->render_payment_mode_field(); return ob_get_clean(); }

    public function checkout_script() {
        if(!is_checkout()) return;
        ?>
        <style>
            .anticwp-box { background: #fff; border: 1px solid #d1d5db; border-radius: 6px; padding: 15px; margin-bottom: 20px; width: 100%; box-sizing: border-box; }
            .anticwp-header { margin: 0 0 10px 0 !important; font-size: 15px !important; font-weight: 600 !important; color: #374151; border-bottom: 1px solid #f3f4f6; padding-bottom: 8px; }
            .anticwp-options-list { display: flex; flex-direction: column; gap: 8px; }
            .anticwp-opt { display: flex !important; align-items: center; padding: 10px; border: 1px solid #e5e7eb; border-radius: 6px; background: #f9fafb; cursor: pointer; transition: all 0.2s; margin: 0 !important; width: 100%; box-sizing: border-box; }
            .anticwp-opt:hover { border-color: #9ca3af; }
            .anticwp-opt.active { background: #eff6ff; border-color: #2563eb; box-shadow: 0 0 0 1px #2563eb inset; }
            .anticwp-radio-wrap { margin-right: 12px; display: flex; align-items: center; }
            .anticwp-radio-wrap input[type="radio"] { width: 18px; height: 18px; accent-color: #2563eb; cursor: pointer; margin: 0; }
            .anticwp-content { display: flex; flex-direction: column; }
            .anticwp-title { font-size: 14px; font-weight: 600; color: #1f2937; line-height: 1.2; }
            .anticwp-desc { font-size: 12px; color: #6b7280; margin-top: 2px; }
            .anticwp-badge { display: inline-block; background: #10b981; color: #fff; font-size: 9px; padding: 1px 6px; border-radius: 4px; font-weight: bold; text-transform: uppercase; margin-top: 2px; width: fit-content; }
        </style>
        <script>jQuery(document).ready(function($){ $('body').on('change','input[name="anticwp_payment_mode"]',function(){ $('.anticwp-opt').removeClass('active'); $(this).closest('.anticwp-opt').addClass('active'); $('body').trigger('update_checkout'); }); });</script>
        <?php
    }

    public function update_session_payment_mode($d){ parse_str($d,$p); if(isset($p['anticwp_payment_mode']) && isset(WC()->session)) WC()->session->set('anticwp_payment_mode',$p['anticwp_payment_mode']); }

    public function apply_fees_logic($c){
        if(is_admin() && !defined('DOING_AJAX')) return;
        if(!isset(WC()->session)) return;
        $m=WC()->session->get('anticwp_payment_mode','split');
        $cf=(float)get_option('anticwp_cod_cost',2.50);
        $cl=get_option('anticwp_cod_label','Antik');
        $pt=$c->cart_contents_total;
        if($m==='split'){ $c->add_fee('Πληρωμή στην Παράδοση (Αφαίρεση)', -1*$pt, true, ''); if($cf>0) $c->add_fee($cl, $cf, true, ''); }
    }

    public function override_shipping_costs( $rates, $package ) {
        $fixed_cost = (float) get_option( 'anticwp_shipping_cost', 5.00 );
        $custom_label = get_option( 'anticwp_shipping_label', 'Έξοδα Μεταφορικά (Πληρωμή Online)' );

        foreach ( $rates as $rate_key => $rate ) {
            $rates[$rate_key]->cost = $fixed_cost;
            $rates[$rate_key]->label = $custom_label;
            if ( isset( $rates[$rate_key]->name ) ) {
                $rates[$rate_key]->name = $custom_label;
            }
        }
        return $rates;
    }

    
    public function force_fresh_shipping_label( $label, $rate ) {
        $custom_label = get_option( 'anticwp_shipping_label' );
        if ( ! empty( $custom_label ) ) {
            return $custom_label;
        }
        return $label;
    }

   
    public function add_settings_to_shipping_hash( $packages ) {
        $cost = get_option( 'anticwp_shipping_cost' );
        $label = get_option( 'anticwp_shipping_label' );
        
        foreach ( $packages as $i => $package ) {
            // Προσθέτουμε μια μεταβλητή παράμετρο που εξαρτάται από τις ρυθμίσεις
            $packages[$i]['anticwp_params'] = array(
                'cost' => $cost,
                'label' => $label
            );
        }
        return $packages;
    }

    public function disable_default_cod($g){ if(isset($g['cod'])) unset($g['cod']); return $g; }

    public function add_pay_later_row($rows,$order,$tax){
        $is_split=false; foreach($order->get_fees() as $f){ if($f->get_total()<0){ $is_split=true; break; } }
        if(!$is_split) return $rows;
        $total=0; foreach($order->get_items() as $i) $total+=$i->get_total();
        
        // Αφαιρέθηκαν τα έντονα γράμματα (strong/b) από την ετικέτα
        // Η wc_price επιστρέφει standard HTML, δεν επεμβαίνουμε με extra bold
        $new=['pay_later'=>['label'=>'Πληρωμή στον Courier:','value'=>wc_price($total)]];
        
        $sorted=[]; $ck=false; $cl=get_option('anticwp_cod_label');
        foreach($rows as $k=>$v){ if(strpos(strip_tags($v['label']), strip_tags($cl))!==false){$ck=$k;break;} }
        foreach($rows as $k=>$v){ if($k==='shipping'){ if($ck && isset($rows[$ck])) $sorted[$ck]=$rows[$ck]; $sorted[$k]=$v; } elseif($k===$ck) continue; else $sorted[$k]=$v; }
        if(empty($sorted)) $sorted=$rows;
        return array_merge($sorted, $new);
    }

    public function track_anticwp_usage($oid){ $k=get_option('anticwp_license_key'); if(!empty($k)) wp_remote_post('https://myin.gr/wp-json/anticad/v1/track', ['body'=>['license_key'=>$k],'blocking'=>false,'sslverify'=>false]); }
}
?>