<?php

class AnticWP_Admin {
    private $license;

    public function __construct( $license ) {
        $this->license = $license;
        add_action( 'admin_menu', array( $this, 'add_menu' ) );
        add_action( 'admin_init', array( $this, 'register_settings' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_styles' ) );
    }

    public function enqueue_styles() {
        wp_enqueue_style( 'anticwp-admin-style', ANTICWP_URL . 'assets/css/admin-style.css', array(), ANTICWP_VERSION );
    }

    public function add_menu() {
        add_submenu_page( 'woocommerce', 'AnticWP Settings', 'AnticWP Payments', 'manage_woocommerce', 'anticwp-settings', array( $this, 'render_page' ) );
    }

    public function register_settings() {
        register_setting( 'anticwp_group', 'anticwp_shipping_cost' );
        register_setting( 'anticwp_group', 'anticwp_cod_cost' );
        register_setting( 'anticwp_group', 'anticwp_shipping_label' );
        register_setting( 'anticwp_group', 'anticwp_cod_label' );
        register_setting( 'anticwp_group', 'anticwp_is_enabled' );
        register_setting( 'anticwp_group', 'anticwp_cache_compatible' ); 

        if ( isset( $_POST['anticwp_activate_license'] ) ) {
            check_admin_referer( 'anticwp_license_action' );
            $key = sanitize_text_field( $_POST['license_key'] );
            if ( $this->license->activate( $key ) ) {
                add_settings_error( 'anticwp', 'active', 'Το Plugin ενεργοποιήθηκε!', 'success' );
            } else {
                add_settings_error( 'anticwp', 'error', 'Μη έγκυρο κλειδί.', 'error' );
            }
        }
    }

    public function render_page() {
        $this->license->check_license_status();

        $status_label = $this->license->get_status_label();
        $is_active = $this->license->is_valid();
        
        $expiry_date = get_option( 'anticwp_license_expiry' );
        $days_left = 'UNLIMITED';
        $expiry_display = 'Unlimited (2099)';
        $is_unlimited = false;
        
        if ( $is_active && ! empty( $expiry_date ) ) {
            $d_start = new DateTime( 'now' );
            $d_end   = new DateTime( $expiry_date );
            
            // Έλεγχος αν η ημερομηνία είναι > 2090
            $year = $d_end->format('Y');
            
            if ($year > 2090) {
                $is_unlimited = true;
                $days_left = 'UNLIMITED';
                $expiry_display = 'Απεριόριστη';
            } else {
                if ( $d_start < $d_end ) {
                    $days_left = $d_start->diff( $d_end )->days;
                    $expiry_display = date_i18n( 'd/m/Y', strtotime( $expiry_date ) );
                } else {
                    $days_left = 0;
                    $expiry_display = 'Έληξε';
                }
            }
        }
        
        $enabled = get_option('anticwp_is_enabled', 'yes');
        $cache_compatible = get_option('anticwp_cache_compatible', 'no');
        ?>

        <div class="wrap anticwp-wrap">
            
            <div class="anticwp-hero">
                <div class="hero-content">
                    <h1>
                        <div class="hero-icon"><span class="dashicons dashicons-tickets-alt"></span></div>
                        AnticWP
                    </h1>
                    <p>Split Payment Gateway for WooCommerce</p>
                </div>
                <div class="version-badge">
                    <span class="version-label">Version</span>
                    <?php echo ANTICWP_VERSION; ?>
                </div>
            </div>

            <div class="anticwp-grid">
                
                <!-- Settings Column -->
                <div class="main-column">
                    <form method="post" action="options.php">
                        <?php settings_fields( 'anticwp_group' ); ?>
                        
                        <div class="anticwp-card">
                            <div class="card-header">
                                <h2><span class="dashicons dashicons-cart header-icon"></span> Ρυθμίσεις Χρεώσεων</h2>
                            </div>
                            
                            <div class="card-body">
                                <div class="input-row">
                                    <label class="input-label">Λειτουργία Plugin</label>
                                    <select name="anticwp_is_enabled" class="anticwp-input" style="max-width: 200px;">
                                        <option value="yes" <?php selected($enabled, 'yes'); ?>>Ενεργό</option>
                                        <option value="no" <?php selected($enabled, 'no'); ?>>Ανενεργό</option>
                                    </select>
                                </div>

                                <div class="divider"></div>

                                <!-- Shipping Section -->
                                <div class="section-block">
                                    <h3 class="section-title">
                                        <div class="icon-box blue"><span class="dashicons dashicons-truck"></span></div>
                                        Μεταφορικά
                                    </h3>
                                    <p class="section-desc">Ορίστε το κόστος που χρεώνεται online και τον τίτλο που βλέπει ο πελάτης.</p>
                                    
                                    <div class="input-row">
                                        <label class="input-label">Κόστος (€)</label>
                                        <input type="number" step="0.01" name="anticwp_shipping_cost" class="anticwp-input" value="<?php echo esc_attr( get_option( 'anticwp_shipping_cost', '5.00' ) ); ?>" />
                                    </div>
                                    <div class="input-row">
                                        <label class="input-label">Τίτλος στο Checkout</label>
                                        <input type="text" name="anticwp_shipping_label" class="anticwp-input" value="<?php echo esc_attr( get_option( 'anticwp_shipping_label', 'Έξοδα Μεταφορικά (Πληρωμή Online)' ) ); ?>" />
                                        <p class="description" style="font-size: 11px; color: #666; margin-top: 5px;">
                                            Αυτό το κείμενο εμφανίζεται στη γραμμή των μεταφορικών στο ταμείο.
                                        </p>
                                    </div>
                                </div>

                                <div class="divider"></div>

                                <!-- COD Section -->
                                <div class="section-block">
                                    <h3 class="section-title">
                                        <div class="icon-box green"><span class="dashicons dashicons-money-alt"></span></div>
                                        Αντικαταβολή
                                    </h3>
                                    <p class="section-desc">Το κόστος της υπηρεσίας αντικαταβολής που προπληρώνεται.</p>
                                    
                                    <div class="input-row">
                                        <label class="input-label">Κόστος (€)</label>
                                        <input type="number" step="0.01" name="anticwp_cod_cost" class="anticwp-input" value="<?php echo esc_attr( get_option( 'anticwp_cod_cost', '2.50' ) ); ?>" />
                                    </div>
                                    <div class="input-row">
                                        <label class="input-label">Τίτλος στο Checkout</label>
                                        <input type="text" name="anticwp_cod_label" class="anticwp-input" value="<?php echo esc_attr( get_option( 'anticwp_cod_label', 'Έξοδα Αντικαταβολής (Πληρωμή Online)' ) ); ?>" />
                                    </div>
                                </div>

                                <div class="divider"></div>

                                <!-- Cache Compatibility Section -->
                                <div class="section-block">
                                    <h3 class="section-title">
                                        <div class="icon-box" style="background:#fff7ed; color:#ea580c;"><span class="dashicons dashicons-performance"></span></div>
                                        Συμβατότητα Cache
                                    </h3>
                                    <p class="section-desc">Ενεργοποιήστε το αν χρησιμοποιείτε caching plugins (WP Rocket, LiteSpeed, Cloudflare).</p>
                                    
                                    <div class="input-row">
                                        <label class="input-label">Cache Compatibility Mode</label>
                                        <select name="anticwp_cache_compatible" class="anticwp-input" style="max-width: 200px;">
                                            <option value="yes" <?php selected($cache_compatible, 'yes'); ?>>Ενεργό</option>
                                            <option value="no" <?php selected($cache_compatible, 'no'); ?>>Ανενεργό</option>
                                        </select>
                                        <p class="description" style="font-size: 11px; color: #666; margin-top: 5px;">
                                            Προσθέτει μοναδική χρονική σήμανση στα αιτήματα επαλήθευσης άδειας για να παρακάμπτεται η cache.
                                        </p>
                                    </div>
                                </div>

                            </div>
                            
                            <div class="card-footer">
                                <button type="submit" class="save-btn">
                                    <span class="dashicons dashicons-saved"></span> Αποθήκευση Αλλαγών
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- License Column -->
                <div class="sidebar-column">
                    <div class="anticwp-card">
                        <div class="card-header">
                            <h2><span class="dashicons dashicons-shield header-icon"></span> Άδεια Χρήσης</h2>
                            <?php if ( $is_active ) : ?>
                                <span class="status-badge active"><span class="dashicons dashicons-yes" style="font-size:14px;width:14px;"></span> ΕΝΕΡΓΗ</span>
                            <?php else: ?>
                                <span class="status-badge invalid">ΑΝΕΝΕΡΓΗ</span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="card-body">
                            <form method="post" action="">
                                <?php wp_nonce_field( 'anticwp_license_action' ); ?>
                                <div class="license-key-wrapper">
                                    <span class="dashicons dashicons-admin-network"></span>
                                    <input type="text" name="license_key" 
                                           value="<?php echo esc_attr( get_option( 'anticwp_license_key' ) ); ?>" 
                                           class="anticwp-input license-input" 
                                           placeholder="ANTICWP-XXXX-XXXX">
                                </div>
                                <input type="submit" name="anticwp_activate_license" class="verify-btn" value="Ενεργοποίηση & Έλεγχος">
                            </form>

                            <?php if ( $is_active ) : ?>
                                <div class="expiry-widget">
                                    <div class="widget-label">Υπολοιπο Χρονου</div>
                                    <div class="widget-value">
                                        <?php if ($is_unlimited): ?>
                                            <span style="font-size: 40px; line-height: 1;">&infin;</span>
                                        <?php else: ?>
                                            <?php echo $days_left; ?>
                                        <?php endif; ?>
                                        <span class="widget-unit"><?php echo $is_unlimited ? 'Lifetime' : 'Ημέρες'; ?></span>
                                    </div>
                                    <?php if (!$is_unlimited): ?>
                                        <div class="widget-date">Λήξη: <?php echo $expiry_display; ?></div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <?php
    }
}
?>