<?php
/**
 * Plugin Name: AnticWP - Split Payment System
 * Description: Σύστημα διαχωρισμού πληρωμών για WooCommerce. Επιτρέπει την online εξόφληση εξόδων (Μεταφορικά/Αντικαταβολή) και την εξόφληση προϊόντων στην πόρτα.
 * Version: 1.6.0
 * Author: MyIn.gr
 * Author URI: https://myin.gr
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}


define( 'ANTICWP_VERSION', '1.6.0' );
define( 'ANTICWP_PATH', plugin_dir_path( __FILE__ ) );
define( 'ANTICWP_URL', plugin_dir_url( __FILE__ ) );



require_once plugin_dir_path( __FILE__ ) . 'update-version.php';




if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    return;
}


require_once ANTICWP_PATH . 'includes/class-anticwp-license.php';
require_once ANTICWP_PATH . 'includes/class-anticwp-admin.php';
require_once ANTICWP_PATH . 'includes/class-anticwp-core.php';
require_once ANTICWP_PATH . 'includes/class-anticwp-orders.php'; // ΣΗΜΑΝΤΙΚΟ: Φόρτωση του Orders Class


add_filter( 'cron_schedules', 'anticwp_add_cron_interval' );
function anticwp_add_cron_interval( $schedules ) {
    $schedules['five_minutes'] = array(
        'interval' => 300,
        'display'  => __( 'Every 5 Minutes' )
    );
    return $schedules;
}


function anticwp_init() {
    
    $license = new AnticWP_License();

    
    new AnticWP_Admin( $license );

    
    new AnticWP_Core( $license );
    
    
    
    new AnticWP_Orders( $license );

    
    add_action( 'anticwp_daily_license_check', array( $license, 'check_license_status' ) );
}
add_action( 'plugins_loaded', 'anticwp_init' );


register_activation_hook( __FILE__, 'anticwp_activate_cron' );
function anticwp_activate_cron() {
    if ( ! wp_next_scheduled( 'anticwp_daily_license_check' ) ) {
        wp_schedule_event( time(), 'five_minutes', 'anticwp_daily_license_check' );
    }
}


register_deactivation_hook( __FILE__, 'anticwp_deactivate_cron' );
function anticwp_deactivate_cron() {
    wp_clear_scheduled_hook( 'anticwp_daily_license_check' );
}